DROP PROCEDURE [hips].[HL7MessageLogInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 25 July 2012
-- Description:   Inserts a new record into the HL7 Message Log Table
-- 16/04/2013 - sbiber - Column IsSuccessful bit changed to QueueStatusId int
-- =============================================
CREATE PROCEDURE [hips].[HL7MessageLogInsert] 
(
		@HospitalID INT =NULL
       ,@HospitalPatientIdentifier VARCHAR(20)=NULL
       ,@SendingApplication	VARCHAR(180) =NULL
       ,@SendingFacility VARCHAR(180) = NULL
       ,@MessageControlId VARCHAR(25) = NULL
       ,@DateTimeOfMessage DATETIME = NULL
       ,@QueueStatusId INT 
       ,@ShouldRetry BIT
       ,@RetryCount INT 
       ,@FailureReason VARCHAR(256) = NULL
       ,@FullMessage VARCHAR(MAX) 
       ,@UserModified VARCHAR(256)
)								    
AS								   
BEGIN	
    SET NOCOUNT ON
    DECLARE @intErrorCode int
      ,@HL7MessageLogId INT
    SET @intErrorCode = 0						   
				   
	INSERT INTO [hips].[HL7MessageLog]
	        ( HospitalId ,
	          HospitalPatientIdentifier ,
	          SendingApplication ,
	          SendingFacility ,
	          MessageControlId ,
	          DateTimeOfMessage ,
	          QueueStatusId ,
	          ShouldRetry ,
	          RetryCount ,
	          FailureReason ,
	          FullMessage ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
VALUES
	(
		@HospitalID
       ,@HospitalPatientIdentifier
       ,@SendingApplication
       ,@SendingFacility
       ,@MessageControlId
       ,@DateTimeOfMessage
       ,@QueueStatusId
       ,@ShouldRetry
       ,@RetryCount
       ,@FailureReason
       ,@FullMessage
      , GETDATE()
      , @UserModified
      , GETDATE()
      , @UserModified
	)
SELECT @intErrorCode = @@ERROR 
           , @HL7MessageLogId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT  [HL7MessageLogID]
			   ,[HospitalID]
			   ,[HospitalPatientIdentifier]
			   ,[SendingApplication]
			   ,[SendingFacility]
			   ,[MessageControlId]
			   ,[DateTimeOfMessage]
			   ,[QueueStatusId]
			   ,[ShouldRetry]
			   ,[RetryCount]
			   ,[FailureReason]
			   ,[FullMessage]
			   ,[DateCreated]
			   ,[UserCreated]
			   ,[DateModified]
			   ,[UserModified]
           FROM [hips].[HL7MessageLog] 
           WHERE [HL7MessageLogId] = @HL7MessageLogId
    END
    RETURN(@intErrorCode)
    
END

GO

